/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.camera.viewfinder;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.camera.viewfinder.Viewfinder;
import io.github.mortuusars.exposure.client.gui.Widgets;
import io.github.mortuusars.exposure.client.gui.component.CycleButton;
import io.github.mortuusars.exposure.client.gui.screen.camera.button.FocalLengthButton;
import io.github.mortuusars.exposure.client.gui.screen.camera.button.FrameCounterButton;
import io.github.mortuusars.exposure.client.gui.screen.camera.button.ShutterSpeedButton;
import io.github.mortuusars.exposure.client.input.KeyboardHandler;
import io.github.mortuusars.exposure.client.input.MouseHandler;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.client.util.ZoomDirection;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.serverbound.ActiveCameraReleaseC2SP;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.camera.component.CompositionGuide;
import io.github.mortuusars.exposure.world.camera.component.CompositionGuides;
import io.github.mortuusars.exposure.world.camera.component.FlashMode;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import io.github.mortuusars.exposure.world.item.camera.CameraSettings;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import net.minecraft.class_8208;
import net.minecraft.class_8666;
import org.jetbrains.annotations.NotNull;

public class ViewfinderCameraControlsScreen
extends class_437 {
    public static final class_8666 SHUTTER_SPEED_SPRITES = new class_8666(Exposure.resource("camera_controls/shutter_speed_dial"), Exposure.resource("camera_controls/shutter_speed_dial_disabled"), Exposure.resource("camera_controls/shutter_speed_dial_highlighted"));
    public static final class_8666 FOCAL_LENGTH_SPRITES = new class_8666(Exposure.resource("camera_controls/focal_length"), Exposure.resource("camera_controls/focal_length_disabled"), Exposure.resource("camera_controls/focal_length_highlighted"));
    public static final class_8666 FRAME_COUNTER_SPRITES = new class_8666(Exposure.resource("camera_controls/frame_counter"), Exposure.resource("camera_controls/frame_counter_disabled"), Exposure.resource("camera_controls/frame_counter_highlighted"));
    public static final class_2960 SEPARATOR_SPRITE = Exposure.resource("camera_controls/button_separator");
    protected static final int SEPARATOR_WIDTH = 1;
    protected static final int BUTTON_HEIGHT = 18;
    protected static final int SIDE_BUTTONS_WIDTH = 48;
    protected static final int BUTTON_WIDTH = 15;
    protected final Camera camera;
    protected final Viewfinder viewfinder;
    protected final long openedAt;
    protected int leftPos;
    protected int topPos;

    public ViewfinderCameraControlsScreen(Camera camera, Viewfinder viewfinder) {
        super(class_5244.field_39003);
        this.camera = camera;
        this.viewfinder = viewfinder;
        this.openedAt = Minecrft.level().method_8510();
    }

    public Camera getCamera() {
        return this.camera;
    }

    public Viewfinder getViewfinder() {
        return this.viewfinder;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25393() {
        this.refreshMovementKeys();
        class_310.method_1551().method_1508();
    }

    protected void method_25426() {
        super.method_25426();
        this.refreshMovementKeys();
        this.leftPos = (this.field_22789 - 256) / 2;
        this.topPos = Math.round(this.viewfinder.overlay().getOpening().y + this.viewfinder.overlay().getOpening().height - 256.0f);
        boolean hasFlash = this.camera.map(CameraItem::hasFlash).orElse(false);
        int elementX = this.leftPos + 128 - (65 + (hasFlash ? 16 : 0) + 48) / 2;
        int elementY = this.topPos + 238;
        class_4185 shutterSpeedButton = this.createShutterSpeedButton();
        this.method_37063((class_364)shutterSpeedButton);
        FocalLengthButton focalLengthButton = new FocalLengthButton(elementX, elementY, 48, 18, FOCAL_LENGTH_SPRITES);
        focalLengthButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure.camera_controls.focal_length.tooltip")));
        this.method_37060((class_4068)focalLengthButton);
        this.addSeparator(elementX += focalLengthButton.method_25368(), elementY);
        class_4185 compositionGuideButton = this.createCompositionGuideButton();
        compositionGuideButton.method_46421(++elementX);
        compositionGuideButton.method_46419(elementY);
        this.method_37063((class_364)compositionGuideButton);
        this.addSeparator(elementX += compositionGuideButton.method_25368(), elementY);
        ++elementX;
        if (hasFlash) {
            class_4185 flashModeButton = this.createFlashModeButton();
            flashModeButton.method_46421(elementX);
            flashModeButton.method_46419(elementY);
            this.method_37063((class_364)flashModeButton);
            this.addSeparator(elementX += flashModeButton.method_25368(), elementY);
            ++elementX;
        }
        FrameCounterButton frameCounterButton = new FrameCounterButton(elementX, elementY, 48, 18, FRAME_COUNTER_SPRITES);
        this.method_37060((class_4068)frameCounterButton);
    }

    @NotNull
    protected class_4185 createShutterSpeedButton() {
        List<ShutterSpeed> shutterSpeeds = this.camera.map((item, stack) -> item.getAvailableShutterSpeeds(), List.of(ShutterSpeed.DEFAULT));
        ShutterSpeed currentShutterSpeed = this.camera.map(CameraSettings.SHUTTER_SPEED::getOrDefault, ShutterSpeed.DEFAULT);
        return new ShutterSpeedButton(this.leftPos + 94, this.topPos + 226, 69, 12, shutterSpeeds, currentShutterSpeed, speed -> SHUTTER_SPEED_SPRITES).setDefaultTooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure.camera_controls.shutter_speed.tooltip"))).onCycle(speed -> CameraSettings.SHUTTER_SPEED.setAndSync(this.camera, (ShutterSpeed)speed));
    }

    @NotNull
    protected class_4185 createCompositionGuideButton() {
        List<CompositionGuide> guides = CompositionGuides.getGuides();
        CompositionGuide currentGuide = this.camera.map(CameraSettings.COMPOSITION_GUIDE::getOrDefault, CompositionGuides.NONE);
        Function<CompositionGuide, class_8666> spritesFunc = guide -> Widgets.threeStateSprites(guide.buttonSpriteLocation());
        return new CycleButton<CompositionGuide>(0, 0, 15, 18, guides, currentGuide, spritesFunc).setDefaultTooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure.camera_controls.composition_guide.tooltip"))).setTooltips(guide -> class_2561.method_43471((String)"gui.exposure.camera_controls.composition_guide.tooltip").method_10852(class_5244.field_33849).method_10852((class_2561)guide.translate().method_27692(class_124.field_1080))).onCycle(guide -> CameraSettings.COMPOSITION_GUIDE.setAndSync(this.camera, (CompositionGuide)guide));
    }

    @NotNull
    protected class_4185 createFlashModeButton() {
        List<FlashMode> modes = Arrays.asList(FlashMode.values());
        FlashMode currentMode = this.camera.map(CameraSettings.FLASH_MODE::getOrDefault, FlashMode.OFF);
        Function<FlashMode, class_8666> spritesFunc = mode -> Widgets.threeStateSprites(Exposure.resource("camera_controls/flash_mode/flash_" + mode.method_15434()));
        return new CycleButton<FlashMode>(0, 0, 15, 18, modes, currentMode, spritesFunc).setDefaultTooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure.camera_controls.flash_mode.tooltip"))).setTooltips(mode -> class_2561.method_43471((String)"gui.exposure.camera_controls.flash_mode.tooltip").method_10852(class_5244.field_33849).method_10852((class_2561)mode.translate().method_27692(class_124.field_1080))).onCycle(mode -> CameraSettings.FLASH_MODE.setAndSync(this.camera, (FlashMode)((Object)mode)));
    }

    protected void addSeparator(int x, int y) {
        class_8208 sprite = class_8208.method_52720((int)1, (int)18, (class_2960)SEPARATOR_SPRITE);
        sprite.method_46421(x);
        sprite.method_46419(y);
        this.method_37060((class_4068)sprite);
    }

    protected void refreshMovementKeys() {
        Consumer<class_304> update = keyMapping -> {
            if (keyMapping.field_1655.method_1442() == class_3675.class_307.field_1672) {
                keyMapping.method_23481(MouseHandler.isMouseButtonHeld(keyMapping.field_1655.method_1444()));
            } else {
                long windowId = class_310.method_1551().method_22683().method_4490();
                keyMapping.method_23481(class_3675.method_15987((long)windowId, (int)keyMapping.field_1655.method_1444()));
            }
        };
        update.accept(KeyboardHandler.getCameraControlsKey());
        class_315 opt = Minecrft.options();
        update.accept(opt.field_1894);
        update.accept(opt.field_1881);
        update.accept(opt.field_1913);
        update.accept(opt.field_1849);
        update.accept(opt.field_1903);
        update.accept(opt.field_1867);
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.viewfinder.isLookingThrough()) {
            this.method_25419();
            return;
        }
        if (Minecrft.options().field_1842) {
            return;
        }
        guiGraphics.method_51448().method_22903();
        float viewfinderScale = this.viewfinder.overlay().getScale();
        if (viewfinderScale != 1.0f) {
            guiGraphics.method_51448().method_46416((float)this.field_22789 / 2.0f, (float)this.field_22790 / 2.0f, 0.0f);
            guiGraphics.method_51448().method_22905(viewfinderScale, viewfinderScale, viewfinderScale);
            guiGraphics.method_51448().method_46416((float)(-this.field_22789) / 2.0f, (float)(-this.field_22790) / 2.0f, 0.0f);
        }
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_51448().method_22909();
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 1) {
            if (this.camera.isActive()) {
                this.camera.release();
                Packets.sendToServer(ActiveCameraReleaseC2SP.INSTANCE);
            }
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (KeyboardHandler.getCameraControlsKey().method_1433(button) || ((Boolean)Config.Client.VIEWFINDER_MIDDLE_CLICK_CONTROLS.get()).booleanValue() && button == 2) {
            if (this.isToggleTimeReached()) {
                this.method_25419();
            }
            return false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.method_25403(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (button != 0) {
            return false;
        }
        if (this.camera.inSelfieMode() && Minecrft.options().field_1867.field_1653) {
            this.viewfinder.selfie.rotateCamera(dragY, dragX, true);
            return true;
        }
        double fov = this.viewfinder.zoom().getCurrentFov();
        int windowWidth = Minecrft.get().method_22683().method_4506();
        int windowHeight = Minecrft.get().method_22683().method_4506();
        double xRot = dragY / (double)windowHeight * fov;
        double yRot = dragX / (double)windowWidth * (fov * ((double)windowHeight / (double)windowWidth));
        Minecrft.player().method_5872(-yRot * 20.0, -xRot * 20.0);
        return true;
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (KeyboardHandler.getCameraControlsKey().method_1417(keyCode, scanCode)) {
            if (this.isToggleTimeReached()) {
                this.method_25419();
            }
            return false;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    protected boolean isToggleTimeReached() {
        return Minecrft.level().method_8510() - this.openedAt >= 5L;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 334 || keyCode == 61) {
            this.viewfinder.zoom().zoom(ZoomDirection.IN, true);
            return true;
        }
        if (keyCode == 333 || keyCode == 45) {
            this.viewfinder.zoom().zoom(ZoomDirection.OUT, true);
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!super.method_25401(mouseX, mouseY, scrollX, scrollY)) {
            this.viewfinder.zoom().zoom(scrollY > 0.0 ? ZoomDirection.IN : ZoomDirection.OUT, true);
            return true;
        }
        return false;
    }
}

